<?php namespace Visiosoft\BankidModule\Bankid;
use Dimafe6\BankID\Model\CollectResponse;
use Dimafe6\BankID\Model\OrderResponse;
use Dimafe6\BankID\Service\BankIDService;

class BankidApiCollection
{
    const TEST_PERSONAL_NUMBER = '199202271434';

    /**
     * @var BankIDService $bankIDService
     */
    private $bankIDService;

    public function __construct()
    {
        $this->bankIDService = new BankIDService(
            'https://appapi2.test.bankid.com/rp/v5.1/',
            isset($_SERVER["REMOTE_ADDR"]) ? $_SERVER["REMOTE_ADDR"] : '127.0.0.1',
            [
                'verify' => false,
                'cert' => [''.__DIR__.'/ssl/fp.p12', "qwerty123"],
            ]
        );
    }

    public function sign()
    {
        $signResponse = $this->bankIDService->getSignResponse(
            self::TEST_PERSONAL_NUMBER,
            'userVisibleData',
            'userNonVisibleData'
        );

        return $signResponse;
    }

    public function collectSign($signResponse)
    {
        $collectResponse = $this->bankIDService->collectResponse($signResponse->orderRef);

        return $collectResponse;
    }

    public function show()
    {
        $resp = $this->collectSign($this->sign());
        return [$resp->orderRef, $resp->status, $resp->hintCode];
    }

}