<?php namespace Visiosoft\BalancesModule\Balance;

use Visiosoft\BalancesModule\Balance\Contract\BalanceInterface;
use Anomaly\Streams\Platform\Model\Balances\BalancesBalancesEntryModel;

class BalanceModel extends BalancesBalancesEntryModel implements BalanceInterface
{
    public function getBalancePrice()
    {
        return $this->price;
    }
    public function price()
    {
        return $this->getSalePrice();
    }

    public function getBalance()
    {
        return BalanceModel::query();
    }

    public function isBalance($id)
    {
        return $this->getBalance()->where('balances_balances.id',$id)->first();
    }

    public function approve($id) {
        return $this->isBalance($id)->update(['approved'=> 1]);
    }
}
