<?php namespace Visiosoft\BalancesModule\Balance\Table;


use Anomaly\Streams\Platform\Ui\Table\Component\Filter\Contract\FilterInterface;
use Illuminate\Database\Eloquent\Builder;

class BalanceTableFilters
{
    public function handle(BalanceTableBuilder $builder)
    {
        $builder->setFilters(
            [
                'type' => [
                    'filter' => 'select',
                    'query' => function (Builder $query, FilterInterface $filter) {
                        $value = ($filter->getValue() == "y") ? false : true;
                        $query->where('balance_added', $value);
                    },
                    'options' => [
                        "y" => 'visiosoft.module.balances::field.payment',
                        "n" => 'visiosoft.module.balances::field.balance_added.name',
                    ],
                ],
            ]
        );
    }

}
