<?php namespace Visiosoft\BalancesModule\Balance;

use Visiosoft\BalancesModule\Balance\Contract\BalanceRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class BalanceRepository extends EntryRepository implements BalanceRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var BalanceModel
     */
    protected $model;

    /**
     * Create a new BalanceRepository instance.
     *
     * @param BalanceModel $model
     */
    public function __construct(BalanceModel $model)
    {
        $this->model = $model;
    }
    // balance all records
    public function findByUserId($userId){
        return $this->model->where('balances_balances.user_id', $userId)->get();
    }
    // balance total
    public function calcTotalByUserId($userId){
        $total = $this->calcAddedTotalByUserId($userId) - $this->calcRemovedTotalByUserId($userId);
        return $total;
    }
    public function calcAddedTotalByUserId($userId){
        return $this->model->where('balances_balances.user_id', $userId)->where('balances_balances.approved', 1)->where('balance_added',1)->sum('price');
    }
    public function calcRemovedTotalByUserId($userId){
        return $this->model->where('balances_balances.user_id', $userId)->where('balances_balances.approved', 1)->where('balance_added',0)->sum('price');
    }
}
