<?php namespace Visiosoft\BalancesModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\BalancesModule\Balance\Contract\BalanceRepositoryInterface;
use Illuminate\Http\Request;
use View;
use Visiosoft\BalancesModule\Balance\Form\BalanceFormBuilder;
use Visiosoft\BalancesModule\Balance\BalanceModel;
use Visiosoft\BalancesModule\Package\PackageModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Cart\CartModel;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;

class BalancesFrontController extends PublicController
{

    private $balances;

    public function __construct(BalanceRepositoryInterface $balances)
    {
        parent::__construct();
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $this->balances = $balances;
    }

    public function index()
    {
        $balance = $this->balances->calcTotalByUserId(auth()->user()->id);
        return $balance;
    }

    public function create()
    {
        return View::make('visiosoft.module.balances::balance/create');
    }

    public function save($id)
    {
//        if(isset($request->request->all()['action']) == "save")
//        {
//            $new_balance = $request->request->all();
        //unset($new_balance['action'],$new_balance['_token']);
        $balanceModel = new PackageModel();
        $package = $balanceModel->find($id);
        $new_balance['user_id'] = auth()->user()->id;
        $new_balance['balance_added'] = 1;
        $new_balance['name'] = $package->name;
        $new_balance['balance_note'] = "";
        $new_balance['price'] = $package->limit;

        $balance = new BalanceModel();
        $balance = $balance->create($new_balance);

        $balance->price = $package->price;
        $balance->currency = $package->currency;
        $cart = $this->dispatch(new GetCart());

        // /* @var ConfigurationInterface $configuration */
        // $configuration = $balancex->find($this->route->parameter('id'));
        // dd($configuration);
        $cart->add($balance, 1);

        return redirect('cart');
        // return redirect('/profile#balance')->with('success', $message);
//        }
    }

    public function paymentBalance(Request $request, OrderRepositoryInterface $orderRepository)
    {
        $order_id = $this->request->cookie('order_id');
        $cart = $this->dispatch(new GetCart());
        $balance = $this->balances->calcTotalByUserId(auth()->user()->id);
        if ($balance >= $cart->total) {
            $new_balance['price'] = $cart->total;
            $new_balance['user_id'] = auth()->user()->id;
            $new_balance['balance_added'] = 0;
            $new_balance['approved'] = 1;
            $balance = new BalanceModel();
            $balance = $balance->create($new_balance);
            $orderRepository->approveOrder($order_id);
            return redirect('payment/success/balance');
        } else {
            $orderRepository->rejectOrder($order_id);
            return redirect('payment/fail/balance');
        }
    }

    public function balancesPackageList(PackageModel $packageModel)
    {
        $balancespackage = $packageModel->listPackage();
        $userbalance = $this->index(auth()->user()->id);

        return $this->view->make('visiosoft.module.balances::profile/balances', compact('balancespackage', 'userbalance'));
    }
}