<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBalancesCreatePackageStream extends Migration
{

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'package',
        'title_column' => 'name',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'slug' => [
            'unique' => true,
            'required' => true,
        ],
        'price' => [
            'required' => true
        ],
        'currency' => [
            'required' => true
        ],
        'limit' => [
            'required' => true
        ]
    ];

}
