<?php namespace Visiosoft\BalancesModule\Http\Controller\Admin;

use Visiosoft\BalancesModule\Package\Form\PackageFormBuilder;
use Visiosoft\BalancesModule\Package\Table\PackageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class PackageController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param PackageTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(PackageTableBuilder $table)
    {
        $table->setColumns(['name','price' => [
            'value' => 'entry.price ~" "~ entry.currency',
        ]]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param PackageFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(PackageFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param PackageFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(PackageFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
