<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;

class VisiosoftModuleBalancesCreateBalancesFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
                "mode"   => "search",
            ]
        ],
        'balance_note' => [
            'type' => 'anomaly.field_type.textarea'
        ],
        'price' => [
            'type' => 'anomaly.field_type.decimal',
            'config' => [
                "point"     => ".",
                "decimals"  => 2,
            ]
        ],
        'balance_added' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => 0,
                'mode' => 'checkbox'
            ]
        ],
        'approved' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => 0,
            ]
        ],
        'cart_id' => 'anomaly.field_type.integer',
        'payment_type' => 'anomaly.field_type.text',
        'currency' => [
            'type'     => 'anomaly.field_type.select',
            'config'   => [
                'handler' => 'currencies',
            ],
        ],
        'limit' => 'anomaly.field_type.integer',
    ];

}
