<?php namespace Visiosoft\BalancesModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\BalancesModule\Listener\PaymentType;
use Visiosoft\BalancesModule\Package\Contract\PackageRepositoryInterface;
use Visiosoft\BalancesModule\Package\PackageRepository;
use Anomaly\Streams\Platform\Model\Balances\BalancesPackageEntryModel;
use Visiosoft\BalancesModule\Package\PackageModel;
use Visiosoft\BalancesModule\Balance\Contract\BalanceRepositoryInterface;
use Visiosoft\BalancesModule\Balance\BalanceRepository;
use Anomaly\Streams\Platform\Model\Balances\BalancesBalancesEntryModel;
use Visiosoft\BalancesModule\Balance\BalanceModel;
use Illuminate\Routing\Router;
use Visiosoft\CartsModule\Cart\Event\CartsPay;

class BalancesModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/balances/package' => 'Visiosoft\BalancesModule\Http\Controller\Admin\PackageController@index',
        'admin/balances/package/create' => 'Visiosoft\BalancesModule\Http\Controller\Admin\PackageController@create',
        'admin/balances/package/edit/{id}' => 'Visiosoft\BalancesModule\Http\Controller\Admin\PackageController@edit',
        'admin/balances' => 'Visiosoft\BalancesModule\Http\Controller\Admin\BalancesController@index',
        'admin/balances/create' => 'Visiosoft\BalancesModule\Http\Controller\Admin\BalancesController@create',
        'admin/balances/edit/{id}' => 'Visiosoft\BalancesModule\Http\Controller\Admin\BalancesController@edit',
        'balance/create' => 'Visiosoft\BalancesModule\Http\Controller\BalancesFrontController@create',
        'balance/save/{id}' => [
            'as' => 'visiosoft.module.balances::save',
            'uses' => 'Visiosoft\BalancesModule\Http\Controller\BalancesFrontController@save'
        ],
        'payment/balances' => [
            'as' => 'visiosoft.module.payment::balance',
            'uses' => 'Visiosoft\BalancesModule\Http\Controller\BalancesFrontController@paymentBalance',
        ],
        'admin/balance/approve/{id}' => 'Visiosoft\BalancesModule\Http\Controller\Admin\BalancesController@approve',

        'profile/balances' => [
            'as' => 'balances::packages',
            'uses' => 'Visiosoft\BalancesModule\Http\Controller\BalancesFrontController@balancesPackageList'
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\BalancesModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\BalancesModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        CartsPay::class =>
            [
                PaymentType::class,
            ]
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\BalancesModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        BalancesPackageEntryModel::class => PackageModel::class,
        BalancesBalancesEntryModel::class => BalanceModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        PackageRepositoryInterface::class => PackageRepository::class,
        BalanceRepositoryInterface::class => BalanceRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
