<?php namespace Visiosoft\BalancesModule\Balance\Table;


use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;

class BalanceTableColumns
{
    public function handle(BalanceTableBuilder $builder)
    {
        $builder->setColumns(
            [
                'id' => [
                    'value' => 'entry.id'
                ],
                'user',
                'price' => [
                    'heading' => 'visiosoft.module.balances::field.menu_balance.name',
                    'value' => function (EntryInterface $entry) {
                        $value = ($entry->balance_added) ? "<span class='font-weight-bold'>+ $entry->price</span>": "<span class='text-danger font-weight-bold'>- $entry->price</span>";
                        return $value;
                    }
                ],
                'type' => [
                    'value' => function (EntryInterface $entry) {
                        $text = ($entry->balance_added) ? trans('visiosoft.module.balances::field.balance_added.name'): trans('visiosoft.module.balances::field.payment');
                        return $text;
                    }
                ]
            ]
        );
    }

}
