<?php namespace Visiosoft\BalancesModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\BalancesModule\Balance\BalanceModel;
use Visiosoft\BalancesModule\Balance\Form\BalanceFormBuilder;
use Visiosoft\BalancesModule\Balance\Table\BalanceTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class BalancesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param BalanceTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(BalanceTableBuilder $table)
    {
        $table->addButtons([
            'approve' => [
                'icon' => 'fa fa-check',
                'type' => 'success',
                'href' => 'admin/balance/approve/{entry.id}',
                'text' => function (EntryInterface $entry) {
                    if($entry->approved == 0)
                    {
                        return trans('visiosoft.module.balances::field.approved');
                    } else {
                        return trans('visiosoft.module.balances::field.approve');;
                    }
                },
                'disabled' => function (EntryInterface $entry) {
                    if($entry->approved == 1)
                    {
                        return true;
                    }
                }
            ]
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param BalanceFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(BalanceFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param BalanceFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(BalanceFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function approve($id)
    {
        $this_model = new BalanceModel();
        $this_model->approve($id);
        return back();
    }
}
