<?php namespace Visiosoft\BalancesModule\Balance;

use Carbon\Carbon;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Auth;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;

class BalanceApiCollection extends BalanceRepository
{
    use DispatchesJobs;

    public function add(array $params)
    {
        $this->dispatch(new CheckRequiredParams(['price', 'user_id'], $params));

        return $this->newQuery()
            ->create([
                'created_at' => Carbon::now(),
                'created_by_id' => Auth::id(),
                'user_id' => $params['user_id'],
                'name' => (isset($params['name'])) ? $params['name'] : ' User #' . $params['user_id'] . ' adding balance!',
                'balance_note' => (isset($params['balance_note'])) ? $params['balance_note'] : ' User #' . $params['user_id'] . ' adding balance!',
                'price' => $params['price'],
                'balance_added' => true,
                'approved' => true
            ]);
    }

    public function reduction(array $params)
    {
        $this->dispatch(new CheckRequiredParams(['price', 'user_id'], $params));

        $balance = $this->calcTotalByUserId($params['user_id']);

        if ($balance >= $params['price']) {
            $this->newQuery()
                ->create([
                    'created_at' => Carbon::now(),
                    'created_by_id' => Auth::id(),
                    'user_id' => $params['user_id'],
                    'price' => $params['price'],
                    'balance_added' => false,
                    'approved' => true
                ]);

            return collect([['message' => trans('visiosoft.module.balances::message.transaction_successful')]]);
        } else {
            throw new \Exception(trans('visiosoft.module.balances::message.insufficient_balance'), 400);
        }
    }

    public function myBalance(array $params){

        $this->dispatch(new CheckRequiredParams(['user_id'], $params));

        $balance = $this->calcTotalByUserId($params['user_id']);

        return collect([['balance' => $balance]]);
    }
}
