<?php namespace Visiosoft\BackupsModule\Http\Controller\Admin;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\BackupsModule\Backup\Command\RestoreFileBackup;
use Visiosoft\BackupsModule\File\FileModel;
use Visiosoft\BackupsModule\File\Form\FileFormBuilder;
use Visiosoft\BackupsModule\File\Table\FileTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class FileController extends AdminController
{
    use DispatchesJobs;

    public function index(FileModel $fileModel, FileTableBuilder $table)
    {
        if ($this->request->action == "delete") {
            foreach ($this->request->id as $item) {
                unlink($fileModel->find($item)->path);
            }
        }
        return $table->render();
    }


    public function create(FileFormBuilder $form)
    {
        $form->setFields([
            'title',
        ]);
        return $form->render();
    }

    public function restore(FileModel $fileModel, $id)
    {
        $file_backup = $fileModel->find($id);
        $response = $this->dispatch(new RestoreFileBackup($file_backup->path));
        if ($response['type'] == "error") {
            return back()->withErrors([$response['msg']]);
        }
        return back()->withSuccess([trans('visiosoft.module.backups::field.restored_files')]);
    }


}
