<?php namespace Visiosoft\BackupsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Http\Request;
use Visiosoft\BackupsModule\Backup\BackupModel;
use Visiosoft\BackupsModule\Backup\Command\RestoreBackup;
use Visiosoft\BackupsModule\Backup\Form\BackupFormBuilder;
use Visiosoft\BackupsModule\Backup\Table\BackupTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class BackupController extends AdminController
{
    use DispatchesJobs;

    public function index(BackupModel $backupModel, BackupTableBuilder $table)
    {
        if ($this->request->action == "delete") {
            foreach ($this->request->id as $item) {
                unlink($backupModel->find($item)->path);
            }
        }
        return $table->render();
    }

    public function create(BackupFormBuilder $form)
    {
        $form->setFields([
            'title',
            'addon' => [
                'type' => 'anomaly.field_type.select',
                'label' => 'visiosoft.module.backups::field.title.name',
                'required' => true,
                'config' => [
                    'mode' => 'search',
                    'default_value' => 'anomaly.module.pages',
                    'options' => function (AddonCollection $addons) {
                        return $addons->installed()->mapWithKeys(
                            function ($addon) {
                                return [
                                    $addon->getNamespace() => $addon->getName(),
                                ];
                            }
                        )->toArray();
                    },
                ],
            ],
        ]);
        return $form->render();
    }

    public function restore(BackupModel $backupModel, $id)
    {
        $backup = $backupModel->find($id);
        $response = $this->dispatch(new RestoreBackup($backup->path));
        if($response['type'] == "error")
        {
            return back()->withErrors([$response['msg']]);
        }
        return back()->withSuccess([trans('visiosoft.module.backups::field.restored_database')]);
    }
}
