<?php namespace Visiosoft\BackupsModule\File\Form;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\BackupsModule\Backup\Command\CreateFilesBackup;

class FileFormHandler
{
    use DispatchesJobs;

    public function handle(FileFormBuilder $builder)
    {
        if (!$builder->canSave()) {
            return;
        }

        $entry = $builder->getFormEntry();
        if ($path = $this->dispatch(new CreateFilesBackup())) {
            $entry->setFieldValue('path', $path);
            $entry->save();
            $builder->setFormEntry($entry);
        }
        $builder->saveForm();
    }
}
