<?php namespace Visiosoft\BackupsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\BackupsModule\File\Contract\FileRepositoryInterface;
use Visiosoft\BackupsModule\File\FileRepository;
use Anomaly\Streams\Platform\Model\Backups\BackupsFileEntryModel;
use Visiosoft\BackupsModule\File\FileModel;
use Visiosoft\BackupsModule\Backup\Contract\BackupRepositoryInterface;
use Visiosoft\BackupsModule\Backup\BackupRepository;
use Anomaly\Streams\Platform\Model\Backups\BackupsBackupEntryModel;
use Visiosoft\BackupsModule\Backup\BackupModel;
use Illuminate\Routing\Router;

class BackupsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/backups/file'           => 'Visiosoft\BackupsModule\Http\Controller\Admin\FileController@index',
        'admin/backups/file/create'    => 'Visiosoft\BackupsModule\Http\Controller\Admin\FileController@create',
        'admin/backups/file/edit/{id}' => 'Visiosoft\BackupsModule\Http\Controller\Admin\FileController@edit',
        'admin/backups' => 'Visiosoft\BackupsModule\Http\Controller\Admin\BackupController@index',
        'admin/backups/create' => 'Visiosoft\BackupsModule\Http\Controller\Admin\BackupController@create',
        'admin/backups/restore/{id}' => [
            'as' => 'backups::backup-revert',
            'uses' => 'Visiosoft\BackupsModule\Http\Controller\Admin\BackupController@restore',
        ],
        'admin/backups/file-restore/{id}' => [
            'as' => 'backups::backup-revert-file',
            'uses' => 'Visiosoft\BackupsModule\Http\Controller\Admin\FileController@restore',
        ]
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\BackupsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\BackupsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\BackupsModule\Event\ExampleEvent::class => [
        //    Visiosoft\BackupsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\BackupsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        BackupsFileEntryModel::class => FileModel::class,
        BackupsBackupEntryModel::class => BackupModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        FileRepositoryInterface::class => FileRepository::class,
        BackupRepositoryInterface::class => BackupRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
