<?php namespace Visiosoft\BackupsModule\Backup\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class BackupTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'created_at' => [
            'value' => 'entry.created_at',
        ],
        'addon', 'title',
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'restore' => [
            'type' => 'info',
            'icon' => 'fa fa-undo',
            'href' => '/admin/backups/restore/{entry.id}',
        ],
        'download' => [
            'type' => 'warning',
            'icon' => 'fa fa-download',
            'href' => '/{entry.path}',
        ]
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete',
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'orderBy' => [
            'id' => 'DESC'
        ],
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
