<?php namespace Visiosoft\BackupsModule\Backup\Form;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\BackupsModule\Backup\Command\CreateBackup;

class BackupFormHandler
{
    use DispatchesJobs;

    public function handle(BackupFormBuilder $builder)
    {
        if (!$builder->canSave()) {
            return;
        }

        $entry = $builder->getFormEntry();
        if ($path = $this->dispatch(new CreateBackup(null, $builder->getFormValue('addon')))) {
            $entry->setFieldValue('path',$path);
            $entry->save();
            $builder->setFormEntry($entry);
        }
        $builder->saveForm();
    }
}
