<?php namespace Visiosoft\BackupsModule\Backup\Command;

use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Facades\DB;
use ZipArchive;


class RestoreFileBackup
{

    protected $path;

    public function __construct($path)
    {
        $this->path = $path;
    }

    public function handle(Filesystem $files)
    {
        if (!$files->exists($this->path)) {
            return ['type' => 'error', 'msg' => trans('visiosoft.module.backups::field.file_found')];
        }
        $zip = new ZipArchive;
        $res = $zip->open($this->path);
        if ($res === TRUE) {
            $zip->extractTo('app/default/files-module/');
            $zip->close();
        } else {
            return ['type' => 'error', 'msg' => trans('visiosoft.module.backups::field.dont_open')];
        }
        return ['type' => trans('visiosoft.module.backups::field.success')];
    }
}
