<?php namespace Visiosoft\BackupsModule\Backup\Command;

use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Facades\DB;
use ZipArchive;


class RestoreBackup
{

    protected $path;

    public function __construct($path)
    {
        $this->path = $path;
    }

    public function handle(Filesystem $files)
    {
        if (!$files->exists($this->path)) {
            return ['type' => 'error','msg' => trans('visiosoft.module.backups::field.file_found')];
        }
        $zip = new ZipArchive;
        $res = $zip->open($this->path);
        if ($res === TRUE) {
            $zip->extractTo('backupExtract/');
            $zip->close();
        } else {
            return ['type' => 'error','msg' => trans('visiosoft.module.backups::field.dont_open')];
        }
        $file_path = array_first(glob('backupExtract/*.json'));
        if (!$data = json_decode($files->get($file_path), true)) {
            return ['type' => 'error','msg' => trans('visiosoft.module.backups::field.syntax_error')];
        }

        $appReference = app(Application::class)->getReference();

        foreach ($data as $table => $rows) {
            $table = preg_replace('/^' . $appReference . '_/', '', $table);

            if (starts_with($table, 'applications')) {
                continue;
            }

            DB::table($table)->truncate();

            foreach ($rows as $row) {
                DB::table($table)->insert($row);
            }
        }
        unlink($file_path);
        return ['type' => trans('visiosoft.module.backups::field.success')];
    }
}
