<?php namespace Visiosoft\BackupsModule\Backup\Command;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Addon\Command\GetAddon;
use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Message\MessageBag;
use Carbon\Carbon;
use Illuminate\Contracts\Config\Repository;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\DB;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;
use ZipArchive;

class CreateFilesBackup
{
    use DispatchesJobs;

    public function handle(
        Filesystem $files,
        MessageBag $messages
    )
    {

        $date = Carbon::now()->format('Y-m-d_H-i-s');


        if (!$files->exists('backups')) {
            $files->makeDirectory('backups');
        }

        if (!$files->isDirectory('backups')) {
            return ['type' => 'error', 'msg' => trans('visiosoft.module.backups::field.error_directory'),];
        }

        $rootPath = base_path('public/app/'.env('APPLICATION_REFERENCE', 'default').'/files-module');

        $zip = new ZipArchive();

        $file_path = 'backups/backup_file_'.$date.'.zip';

        $zip->open($file_path, ZipArchive::CREATE | ZipArchive::OVERWRITE);

        $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($rootPath),
            RecursiveIteratorIterator::LEAVES_ONLY
        );

        foreach ($files as $name => $file)
        {
            if (!$file->isDir())
            {
                $filePath = $file->getRealPath();
                $relativePath = substr($filePath, strlen($rootPath) + 1);
                $zip->addFile($filePath, $relativePath);
            }
        }

        return $file_path;
    }
}
