<?php namespace Visiosoft\BackupsModule\Backup\Command;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Addon\Command\GetAddon;
use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Message\MessageBag;
use Carbon\Carbon;
use Illuminate\Contracts\Config\Repository;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\DB;
use ZipArchive;

class CreateBackup
{
    use DispatchesJobs;

    protected $tables;

    protected $addon;

    public function __construct($tables = null, $addon = null)
    {
        if (is_string($addon)) {
            $addon = $this->dispatch(new GetAddon($addon));
        }

        $this->tables = $tables;
        $this->addon = $addon;
    }

    public function handle(
        Filesystem $files,
        MessageBag $messages,
        Repository $config
    )
    {
        $path = base_path('/');

        $date = Carbon::now()->format('Y-m-d_H-i-s');

        $tables = DB::select('SHOW TABLES');

        $includedTables = [];
        $dbConnection = $config->get('database.default');
        $dbName = $config->get("database.connections.{$dbConnection}.database");
        $className = "Tables_in_{$dbName}";
        $appReference = app(Application::class)->getReference();

        if (is_string($this->tables)) {
            $this->tables = explode(',', $this->tables);
        }

        $includedTables = array_merge($includedTables, $this->tables ?: []);

        if ($this->addon) {
            $slug = $this->addon->getSlug();
            $path = $this->addon->getPath();

            if (count($files->glob("{$path}/migrations/*")) > 0) {
                foreach ($tables as $table) {
                    if (starts_with(
                        $table->$className,
                        "{$appReference}_{$slug}_"
                    )) {
                        $includedTables[] = $table->$className;
                    }
                }
            }
        }

        if (count($includedTables)) {
            $tables = $includedTables;
        }

        $backup = [];

        foreach ($tables as $table) {
            if (is_object($table)) {
                $table = $table->$className;
            }

            $table = trim($table);

            if (!starts_with($table, "{$appReference}_")
                && !starts_with($table, 'applications')) {
                $table = "{$appReference}_{$table}";
            }

            array_set($backup, $table, DB::select('SELECT * FROM ' . $table, [1]));
        }

        if (!$files->exists('backups')) {
            $files->makeDirectory('backups');
        }

        if (!$files->isDirectory('backups')) {
            $messages->error(trans('visiosoft.module.backups::field.error_directory'));

            return false;
        }

        $filename = "backup_{$slug}_{$date}.sql.json";


        $zip = new ZipArchive();
        $filezip = "backups/backup_{$slug}_{$date}.zip";

        if ($zip->open($filezip, ZIPARCHIVE::CREATE) !== TRUE) {
            $messages->error(trans('visiosoft.module.backups::field.error_directory'));
        }

        $zip->addFromString($filename, json_encode($backup, true));
        $zip->close();

        return $filezip;
    }
}
