var cityField = $('.homeLocation').find('.citySelection');
var districtField = $('.homeLocation').find('.districtSelection');
var districtArea = $('.homeLocation').find('.districtArea');
var categoryItem = $('.chooseCategory').find('.categoryItem');
var ventorMap = $('.selectVectorMap');
var categorySection = $('.chooseCategory');


cityField.on('change', function (e) {
    var id = cityField.val();

    showCategory(false);

    //Remove old Options
    districtField.html('<option disabled selected>...</option>');

    crud('id=' + id, 'ajax/getDistricts', 'POST', function (callback) {

        //add new Options for Loop
        $.each(callback, function (index, value) {
            addDistrictOption(value.id, value.name);
        });

        if (callback.length > 0) {
            showDistrict(true);
        } else {
            showDistrict(false);
        }
    });
});

function addDistrictOption(value, name) {
    districtField.append("<option value='" + value + "'>" + name + "</option>");
}

function showDistrict(status) {
    var disabled = true;
    var opacity = "0.5";

    if (status) {
        disabled = false;
        opacity = "1";
    }

    districtField.attr('disabled', disabled);
    districtArea.css('opacity', opacity)

}

ventorMap.on('click', function (e) {
    //Get City Name
    let region = e.target.getAttribute('class').split('_');
    var cityName = regions[region[region.length - 1]];

    showCategory(false);

    //Check City
    var city = checkCity(cityName);
    if (city !== null) {
        cityField.val(city.id);
        cityField.trigger('change');
    }
});

function checkCity(name) {
    var city = null;
    $.ajax({
        type: 'get',
        async: false,
        url: '/ajax/get-city?name=' + name,
        success: function (response) {
            if (response.success) {
                city = response.city;
            }
        },
    });
    return city;
}

districtField.on('change', function (e) {
    showCategory(true);
});


function showCategory(status) {
    var cursor = "auto";
    var opacity = "0.5";

    if (status) {
        cursor = "pointer";
        opacity = "1";
    }

    $.each(categoryItem, function (index, category) {
        $(category).css('cursor', cursor);
    });
    categorySection.css('opacity', opacity);
}


categoryItem.on('click', function (e) {
    var slug = $(this).data('slug');

    if (districtField.val() != "" && districtField.val() !== null) {
        //redirect filter
        window.location.href = window.location.origin + '/c/' + slug + '?country=212&city%5B0%5D=' + cityField.val() + '&district%5B0%5D=' + districtField.val();
    }
});
