<?php

return [
    'logo' => [
        'type' => 'anomaly.field_type.file',
        'name' => 'logo',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'address' => [
        'name' => 'address',
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            "default_value" => "1223, Main Street, Anytown New York, 38000 USA",
        ]
    ],
    'phone' => [
        'name' => 'phone',
        'type' => 'anomaly.field_type.text',
        "config" => [
            'type' => 'tel',
            'mask' => '0(999) 999-9999'
        ]
    ],
    'country_for_selection_cities' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\LocationModule\Country\CountryModel::class,
            "default_value" => 212,
        ]
    ],

    // Footer
    'footer_logo' => [
        "type"   => "anomaly.field_type.file",
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'location' => [
        "type"   => "anomaly.field_type.textarea",
        "config" => [
            "default_value" => 'Manhattan, NY 10036, United States',
        ]
    ],
    'contact_number' => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => '+49 162 9574068',
        ]
    ],
    'instagram_link' => [
        "type"   => "anomaly.field_type.url",
        "config" => [
            "default_value" => 'https://www.instagram.com/',
        ]
    ],
    'twitter_link' => [
        "type"   => "anomaly.field_type.url",
        "config" => [
            "default_value" => 'https://twitter.com/',
        ]
    ],
    'facebook_link' => [
        "type"   => "anomaly.field_type.url",
        "config" => [
            "default_value" => 'https://www.facebook.com/',
        ]
    ],
    'whatsapp_number' => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => '0555 000 00 00',
        ]
    ],
    "whatsapp_qr_code" => [
        "type"   => "anomaly.field_type.file",
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
];
