<?php namespace Visiosoft\AutocompleteModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\CategoryModel;

class AutocompleteController extends PublicController
{
    protected $categoryModel;

    public function __construct(CategoryModel $categoryModel)
    {
        $this->categoryModel = $categoryModel;
        parent::__construct();
    }

    public function search(Request $request, AdvRepositoryInterface $advRepository)
    {
        $categories = $this->searchKeyword($request->q);

        foreach ($categories as $index => $category) {
            $categories[$index]['url'] = route('adv_list_seo', [$category['slug']]);
            $categories[$index]['name'] = $category['parents'];
            $categories[$index]['words'] = $request->q;
        }
        $datas['category'] = $categories;

        $ads = $advRepository->searchAdvs(null, ['keyword' => $request->q]);
        foreach ($ads as $ad) {
            $ad->url = $ad->getAdvDetailLinkByModel($ad, 'list');
            $ad->words = $request->q;
        }

        $datas['advs'] = $ads;
        return response()->json($datas);
    }

    public function searchKeyword($keyword)
    {
        $categories = [];

        $cats = DB::table('cats_category');

        $cats = $cats->where('name', 'like', $keyword . '%')
            ->whereRaw('deleted_at IS NULL')
            ->leftJoin('cats_category_translations', function ($join) {
                $join->on('cats_category.id', '=', 'cats_category_translations.entry_id');
                $join->whereIn('cats_category_translations.locale', [config('app.locale'), setting_value('streams::default_locale'), 'en']);//active lang
            })
            ->select('cats_category.*', 'cats_category_translations.name as name')
            ->orderBy('id', 'DESC')->groupBy(['cats_category.id'])->get();

        // Set Parent
        foreach ($cats as $cat) {
            $parent_name = '';

            $parents = $this->categoryModel->getParentCats($cat->id);

            krsort($parents);

            foreach ($parents as $key => $parent) {
                $parent_name .= ($key == 0) ? $parent . '' : $parent . ' > ';
            }

            $categories[] = array(
                'id' => $cat->id,
                'name' => $cat->name,
                'parents' => $parent_name,
                'slug' => $cat->slug,
            );
        }

        return $categories;
    }
}