<?php namespace Visiosoft\AutocompleteModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\CategoryModel;

class AutocompleteController extends PublicController
{
    public function search(Request $request, CategoryModel $categoryModel, AdvRepositoryInterface $advRepository)
    {
        $categories = $categoryModel->searchKeyword($request->q);
        foreach ($categories as $index => $category) {
            $categories[$index]['url'] = route('adv_list_seo', [$category['slug']]);
        }
        $datas['category'] = $categories;

        $ads = $advRepository->searchAdvs(null, ['keyword' => $request->q]);
        foreach ($ads as $ad) {
            $ad->url = $ad->getAdvDetailLinkByModel($ad, 'list');
        }

        $datas['advs'] = $ads;
        return response()->json($datas);
    }
}