//autocomplete
var options = {
    url: function (phrase) {
        if (phrase.length > 2) {
            return autocomplete_search_url + "?q=" + phrase;
        }
    },
    categories: [
        {
            header: translations_autocomplete.category,
            listLocation: "category",
        },
        {
            header: translations_autocomplete.ads,
            listLocation: "advs",
        },
        {
            header: translations_autocomplete.location,
            listLocation: "location",
        }
    ],
    getValue: "parents",
    template: {
        type: "custom",
        method: function (index, item) {
            return "<a href='" + item.url + "'>" + wrapInTag(item.words, item.name) + "</a>";
        }
    }
};

$(document).ready(function () {
    $("#search, #searchMobile, .autocomplete-search").easyAutocomplete(options);
});

function wrapInTag(words, value, tag = 'b') {

    var regex = RegExp(words, 'gi'),
        replacement = '<' + tag + '>$&</' + tag + '>';

    return value.replace(regex, replacement);
}