<?php namespace Visiosoft\AuctionsModule\LiveBid;

use Visiosoft\AuctionsModule\LiveBid\Contract\LiveBidRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class LiveBidRepository extends EntryRepository implements LiveBidRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var LiveBidModel
     */
    protected $model;

    /**
     * Create a new LiveBidRepository instance.
     *
     * @param LiveBidModel $model
     */
    public function __construct(LiveBidModel $model)
    {
        $this->model = $model;
    }

    public function getByStoreId($store_id)
    {
        return $this->newQuery()->where('store_id', $store_id)->get();
    }

    public function findAdByStoreId($store_id, $ad_id)
    {
        return $this->newQuery()->where('store_id', $store_id)->where('adv_id', $ad_id)->first();
    }

    public function getByAdsAndUpdateStatus($items, $status)
    {
        $this->newQuery()->whereIn('adv_id', $items)
            ->update(['status' => $status]);
    }

    public function createNew($store_id, $item_id)
    {
        return $this->newQuery()->create([
            'store_id' => $store_id,
            'adv_id' => $item_id
        ]);
    }

    public function getLiveStores()
    {
        $entries = $this->newQuery()->whereNull('status')
            ->groupBy('store_id')
            ->orderByDesc('id')
            ->get()->pluck('store_id')->all();

        $store_repository = app(StoreRepositoryInterface::class);

        $entries = $store_repository->newQuery()->where('status', 'approved')
            ->whereIn('id', $entries)->get();

        return $entries;
    }
}
