<?php namespace Visiosoft\AuctionsModule\LiveBid;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\AuctionsModule\LiveBid\Contract\LiveBidRepositoryInterface;

class LiveBidCriteria extends EntryCriteria
{
    private $repository;

    public function __construct(
        Builder $query,
        StreamInterface $stream,
        $method,
        LiveBidRepositoryInterface $repository
    )
    {
        parent::__construct($query, $stream, $method);
        $this->repository = $repository;
    }

    public function getLiveStores()
    {
        return $this->repository->getLiveStores();
    }
}
