<?php namespace Visiosoft\AuctionsModule\LiveTime\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\CatsModule\Category\CategoryModel;

class LiveTimeTableBuilder extends TableBuilder
{

    protected $model = CategoryModel::class;

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [
        'all'
    ];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit_time' => [
            'type' => 'warning',
            'href' => '/admin/auctions/edit/{entry.id}?category_id={entry.id}'
        ],
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'sortable' => false,
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

    public function onQuerying(Builder $query)
    {
        $query->where('parent_category_id', null);
    }

}
