<?php namespace Visiosoft\AuctionsModule;

use Visiosoft\AuctionsModule\LiveTime\Contract\LiveTimeRepositoryInterface;
use Visiosoft\AuctionsModule\Offer\Contract\OfferRepositoryInterface;
use Anomaly\Streams\Platform\Addon\Plugin\Plugin;

class AuctionsModulePlugin extends Plugin
{
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getLastBidPrice',
                function ($adv_id, $default_price) {
                    $repository = app(OfferRepositoryInterface::class);

                    $bid = $repository->getLastOfferByAdv($adv_id);

                    return ($bid) ? $bid->bid_price : $default_price;
                }
            ),

            new \Twig_SimpleFunction(
                'getLiveTimeByCategory',
                function ($category_id) {
                    $repository = app(LiveTimeRepositoryInterface::class);
                    return $repository->getLiveTimeByCategory($category_id);
                }
            ),
        ];
    }

}
