<?php namespace Visiosoft\AuctionsModule\Agora;

use Visiosoft\AuctionsModule\Agora\AgoraDynamicKey\RtcTokenBuilder;

class BuildToken
{
    protected $channel_name;
    protected $uid;

    public function __construct($channel_name, $uid)
    {
        $this->channel_name = $channel_name;
        $this->uid = $uid;
    }

    public function handle()
    {
        $app_id = setting_value('visiosoft.module.auctions::agora_app_id');
        $certificate_id = setting_value('visiosoft.module.auctions::agora_certificate_id');

        return [
            'token' => RtcTokenBuilder::buildTokenWithUid(
                $app_id,
                $certificate_id,
                $this->channel_name,
                intval($this->uid),
                RtcTokenBuilder::RoleAttendee,
                now()->getTimestamp() + 31536000
            ),
            'params' => [
                'app_id' => $app_id,
                'certificate_id' => $certificate_id,
                'channel_name' => $this->channel_name,
                'uid' => $this->uid
            ]
        ];
    }
}
