<?php namespace Visiosoft\AuctionsModule\Offer;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Visiosoft\AuctionsModule\Offer\Contract\OfferRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class OfferRepository extends EntryRepository implements OfferRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var OfferModel
     */
    protected $model;

    /**
     * Create a new OfferRepository instance.
     *
     * @param OfferModel $model
     */
    public function __construct(OfferModel $model)
    {
        $this->model = $model;
    }

    public function getOffersByAdv($adv_id, $last = false)
    {

        $query = $this->newQuery()
            ->where('adv_id', $adv_id)
            ->orderByDesc('bid_price');

        return ($last) ? $query->first() : $query->get();
    }

    public function getLastOfferByAdv($adv_id)
    {
        return $this->getOffersByAdv($adv_id, true);
    }

    public function createNew($adv_id, $bid_price, $store_id = null)
    {
        return $this->newQuery()->create([
            'store_id' => $store_id,
            'adv_id' => $adv_id,
            'bid_price' => $bid_price,
        ]);
    }

    public
    function getWinnerByStore($id)
    {
        return $this->newQuery()
            ->where('store_id', $id)
            ->whereDate('created_at', DB::raw('CURDATE()'))
            ->where('status', 'sold')
            ->get();
    }

    public
    function getIWonByStore($id)
    {
        return $this->newQuery()
            ->where('store_id', $id)
            ->where('created_by_id', Auth::id())
            ->whereDate('created_at', DB::raw('CURDATE()'))
            ->where('status', 'sold')
            ->get();
    }

    public function getMyOffers()
    {
        return $this->newQuery()
            ->where('created_by_id', Auth::id())
            ->orderByDesc('id')
            ->paginate(setting_value('streams::per_page'));
    }
}
