<?php namespace Visiosoft\AuctionsModule\LiveTime;

use Visiosoft\AuctionsModule\LiveTime\Contract\LiveTimeRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class LiveTimeRepository extends EntryRepository implements LiveTimeRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var LiveTimeModel
     */
    protected $model;

    /**
     * Create a new LiveTimeRepository instance.
     *
     * @param LiveTimeModel $model
     */
    public function __construct(LiveTimeModel $model)
    {
        $this->model = $model;
    }

    public function getLiveTimeByCategory($category_id)
    {
        return $this->newQuery()->where('category_id', $category_id)
            ->first();
    }
}
