<?php namespace Visiosoft\AuctionsModule\LiveTime\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Visiosoft\AuctionsModule\LiveTime\LiveTimeModel;

class LiveTimeFormBuilder extends FormBuilder
{

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => '/admin/auctions'
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

    public function onReady()
    {
        $live_time = new LiveTimeModel();

        $category_id = request('category_id');

        if ($entry = $live_time->newQuery()->where('category_id', $category_id)->first()) {
            $this->setFormEntry($entry);
        } else {

            $this->setFormEntry($live_time);
            $this->resetForm();
        }
    }

}
