<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleAuctionsCreateLiveTimeStream extends Migration
{
    protected $delete = true;

    protected $stream = [
        'slug' => 'live_time',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'category' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
                'default_value' => null,
            ],
        ],
        "start_time" => [
            "type"   => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => null,
                "mode"          => "time",
            ]
        ],
        "end_time" => [
            "type"   => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => null,
                "mode"          => "time",
            ]
        ]
    ];

    protected $assignments = [
        'category' => [
            'required' => true,
        ],
        'start_time' => [
            'required' => true,
        ],

        'end_time' => [
            'required' => true,
        ],
    ];

}
