<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleAuctionsCreateAuctionsFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'store' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\StoreModule\Store\StoreModel::class,
            ],
        ],
        'adv' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\AdvsModule\Adv\AdvModel::class,
            ],
        ],
        'status' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                "options" => [
                    "sold" => "visiosoft.module.auctions::field.sold",
                    "unsold" => "visiosoft.module.auctions::field.unsold",
                ],
                'default_value' => null
            ],
        ],
        'bid_price' => [
            'type' => 'visiosoft.field_type.decimal',
            'config' => [
                'decimal' => 2,
                'separator' => '.',
                'point' => ','
            ],
        ],
        'offer' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\AuctionsModule\Offer\OfferModel::class,
            ],
        ],
    ];

}
