<?php namespace Visiosoft\AuctionsModule\Http\Controller;

use Anomaly\PagesModule\Page\Contract\PageInterface;
use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AuctionsModule\LiveBid\Contract\LiveBidRepositoryInterface;
use Visiosoft\AuctionsModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\AuctionsModule\Agora\BuildToken;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\OrdersModule\Events\OrderCreated;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class AjaxController extends ResourceController
{

    protected $repository;
    protected $adv;
    protected $customFieldRepository;
    protected $liveBidRepository;
    protected $offerRepository;
    protected $orderModel;
    protected $orderdetailModel;

    public function __construct(
        StoreRepositoryInterface $repository,
        AdvRepositoryInterface $advRepository,
        CustomFieldRepositoryInterface $customFieldRepository,
        LiveBidRepositoryInterface $liveBidRepository,
        OrderModel $orderModel,
        OrderdetailModel $orderdetailModel,
        OfferRepositoryInterface $offerRepository)
    {
        $this->repository = $repository;
        $this->adv = $advRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->liveBidRepository = $liveBidRepository;
        $this->offerRepository = $offerRepository;
        $this->orderModel = $orderModel;
        $this->orderdetailModel = $orderdetailModel;
        parent::__construct();
    }

    public function send($slug)
    {
        if ($store = $this->repository->findBySlug($slug) and $this->request->has(['bid_price', 'id'])) {

            $bid_price = $this->request->bid_price;
            $id = $this->request->id;

            if ($auction_entry = $this->liveBidRepository->findAdByStoreId($store->id, $id) and $entry = $auction_entry->adv) {

                $response_ajax = ['status' => false, 'message' => ''];

                if ($last_request = $this->offerRepository->getLastOfferByAdv($auction_entry->adv_id)) {

                    // Check Last Price
                    if ($last_request->bid_price < $bid_price) {

                        $this->offerRepository->createNew($store->id, $auction_entry->adv_id, $bid_price);
                        $response_ajax['status'] = true;
                    } else {
                        $response_ajax['message'] = trans('visiosoft.module.auctions::messages.error_previous_offer');
                    }

                } elseif ($entry->price < floatval($bid_price)) {

                    // Check Start Price

                    $this->offerRepository->createNew($store->id, $auction_entry->adv_id, $bid_price);
                    $response_ajax['status'] = true;

                } else {
                    $response_ajax['message'] = trans('visiosoft.module.auctions::messages.error_start_price');
                }

                return $this->response->json($response_ajax);
            }
        }
        abort(403);
    }

    public function last($id)
    {
        $offers = $this->offerRepository->getOffersByAdv($id);

        $sold = $offers->filter(
            function ($entry) {
                return $entry->status == "sold";
            }
        );

        if (count($sold)) {
            return $this->response->json(['status' => 'sold']);
        }

        if ($this->request->has('type') and $this->request->type == "view") {
            return $this->view->make('visiosoft.module.auctions::last-offers', compact('offers'));
        }

        return $this->response->json($offers);
    }

    public function complete($slug)
    {
        $response = ["status" => false, "message" => ""];
        if ($store = $this->repository->findBySlug($slug) and $this->request->has(['id', 'offer_id', 'action'])) {
            if ($store->user_id !== \auth()->id()) {
                abort(403, trans('visiosoft.module.store::message.unauthorized_access'));
            }

            $offer_id = $this->request->offer_id;
            $id = $this->request->id;

            $auction_entry = $this->liveBidRepository->findAdByStoreId($store->id, $id);

            if ($auction_entry and $entry = $auction_entry->adv and $offer = $this->offerRepository->find($offer_id)) {
                if ($entry = $this->liveBidRepository->findAdByStoreId($store->id, $auction_entry->adv_id)) {
                    if ($this->request->action == "sold") {
                        $entry->setAttribute('status', 'sold');

                        // Update Ad For Sold
                        $this->soldAd($entry->adv_id, $offer);
                    } else if ($this->request->action == "skip") {
                        $entry->setAttribute('status', 'unsold');
                    }
                    $entry->setAttribute('offer_id', $offer->id);
                    $entry->save();

                    $offer->setAttribute('status', 'sold');
                    $offer->save();

                    $response["status"] = true;
                }
            }
        }
        return $this->response->json($response);
    }

    public function agoraToken()
    {
        $response = ['status' => false];

        if ($this->request->has(['channel_name', 'uid'])) {
            $response['data'] = dispatch_now(new BuildToken($this->request->channel_name, $this->request->uid));
            $response['status'] = true;
        }

        return $this->response->json($response);
    }

    /**
     * @param $id
     * @param $offer
     * It updates the stock number of the sold auction product to 0 in the classifieds table and creates
     * an order for the person who bought the product.
     */
    public function soldAd($id, $offer)
    {
        if ($adv = $this->adv->find($id)) {
            $adv->setAttribute('is_get_adv', true);
            $adv->setAttribute('stock', 0);
            $adv->save();
        }

        // Calculate Total
        $total = setting_value('visiosoft.module.orders::shipping') +
            setting_value('visiosoft.module.orders::tax') +
            $offer->bid_price;

        // Create Order
        $order_id = $this->orderModel->newQuery()->create([
            'user' => $offer->created_by,
            'pay_type' => 'order',
            'total' => $total,
            'type' => 'adv',
            'subtotal' => $offer->bid_price,
            'shipping' => setting_value('visiosoft.module.orders::shipping'),
            'tax' => setting_value('visiosoft.module.orders::tax'),
            'currency' => setting_value('streams::currency'),
            'status' => 'pending',
            'order_at' => date('Y-m-d H:i:s'),
        ]);


        // Create Detail
        $order_detail_params = [
            'item_id' => $id,
            'item_type' => 'adv',
            'price' => $offer->bid_price,
            'currency' => $offer->adv->currency,
            'piece' => 1,
            'total' => $offer->bid_price,
            'order' => $order_id,
            'status' => 'awaiting_payment',
        ];

        $this->orderdetailModel->create_datail($order_detail_params);

        event(new OrderCreated($order_id));
    }

    public function auctionsIwon($id)
    {
        $now = now();

        $products = $this->offerRepository
            ->newQuery()
            ->where('store_id', $id)
            ->where('created_by_id', Auth::id())
            ->whereDate('created_at', DB::raw('CURDATE()'))
            ->get();

        return $this->view->make('visiosoft.module.auctions::partials/auctions-i-won',compact('products'));
    }
}
