<?php namespace Visiosoft\AuctionsModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class AuctionsModuleSeeder extends Seeder
{
    public function run()
    {
        if (is_module_installed('visiosoft.module.customfields')) {
            $customFieldRepository = app(CustomFieldRepositoryInterface::class);
            $customfield_value_repository = app(CfvalueRepositoryInterface::class);

            if (!$customFieldRepository->findBySlug('urun_tipi')) {
                $customfield = $customFieldRepository->newQuery()->create(
                    [
                        'slug' => 'urun_tipi',
                        'name' => 'Ürün Tipi',
                        'type' => 'select',
                        'required' => true
                    ]
                );

                $cf_values = [
                    [
                        'custom_field_value' => 'Standard product',
                        'custom_field_id' => $customfield->getId(),
                    ],
                    [
                        'custom_field_value' => 'Auction product',
                        'custom_field_id' => $customfield->getId(),
                    ]
                ];

                foreach ($cf_values as $cf_value)
                {
                    $customfield_value_repository->newQuery()->create($cf_value);
                }
            }

        }
    }
}