<?php namespace Visiosoft\AuctionsModule\Offer;

use Visiosoft\AuctionsModule\Offer\Contract\OfferRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class OfferRepository extends EntryRepository implements OfferRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var OfferModel
     */
    protected $model;

    /**
     * Create a new OfferRepository instance.
     *
     * @param OfferModel $model
     */
    public function __construct(OfferModel $model)
    {
        $this->model = $model;
    }

    public function getOffersByAdv($adv_id, $last = false)
    {

        $query = $this->newQuery()
            ->where('adv_id', $adv_id)
            ->orderByDesc('bid_price');

        return ($last) ? $query->first() : $query->get();
    }

    public function getLastOfferByAdv($adv_id)
    {
        return $this->getOffersByAdv($adv_id, true);
    }

    public function createNew($store_id, $adv_id, $bid_price)
    {
        return $this->newQuery()->create([
            'store_id' => $store_id,
            'adv_id' => $adv_id,
            'bid_price' => $bid_price,
        ]);
    }
}
