<?php namespace Visiosoft\AuctionsModule\Http\Controller;

use Anomaly\PagesModule\Page\Contract\PageInterface;
use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AuctionsModule\LiveBid\Contract\LiveBidRepositoryInterface;
use Visiosoft\AuctionsModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\AuctionsModule\Agora\BuildToken;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class AjaxController extends ResourceController
{

    protected $repository;
    protected $adv;
    protected $customFieldRepository;
    protected $liveBidRepository;
    protected $offerRepository;

    public function __construct(
        StoreRepositoryInterface $repository,
        AdvRepositoryInterface $advRepository,
        CustomFieldRepositoryInterface $customFieldRepository,
        LiveBidRepositoryInterface $liveBidRepository,
        OfferRepositoryInterface $offerRepository)
    {
        $this->repository = $repository;
        $this->adv = $advRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->liveBidRepository = $liveBidRepository;
        $this->offerRepository = $offerRepository;
        parent::__construct();
    }

    public function send($slug)
    {
        if ($store = $this->repository->findBySlug($slug) and $this->request->has(['bid_price', 'id'])) {

            $bid_price = $this->request->bid_price;
            $id = $this->request->id;

            if ($auction_entry = $this->liveBidRepository->findAdByStoreId($store->id, $id) and $entry = $auction_entry->adv) {

                $response_ajax = ['status' => false, 'message' => ''];

                if ($last_request = $this->offerRepository->getLastOfferByAdv($auction_entry->adv_id)) {

                    // Check Last Price
                    if ($last_request->bid_price < $bid_price) {

                        $this->offerRepository->createNew($store->id, $auction_entry->adv_id, $bid_price);
                        $response_ajax['status'] = true;
                    } else {
                        $response_ajax['message'] = trans('visiosoft.module.auctions::messages.error_previous_offer');
                    }

                } elseif ($entry->price < floatval($bid_price)) {

                    // Check Start Price

                    $this->offerRepository->createNew($store->id, $auction_entry->adv_id, $bid_price);
                    $response_ajax['status'] = true;

                } else {
                    $response_ajax['message'] = trans('visiosoft.module.auctions::messages.error_start_price');
                }

                return $this->response->json($response_ajax);
            }
        }
        abort(403);
    }

    public function last($id)
    {
        $offers = $this->offerRepository->getOffersByAdv($id);

        $sold = $offers->filter(
            function ($entry) {
                return $entry->status == "sold";
            }
        );

        if (count($sold)) {
            return $this->response->json(['status' => 'sold']);
        }

        if ($this->request->has('type') and $this->request->type == "view") {
            return $this->view->make('visiosoft.module.auctions::last-offers', compact('offers'));
        }

        return $this->response->json($offers);
    }

    public function complete($slug)
    {
        $response = ["status" => false, "message" => ""];
        if ($store = $this->repository->findBySlug($slug) and $this->request->has(['id', 'offer_id', 'action'])) {
            if ($store->user_id !== \auth()->id()) {
                abort(403, trans('visiosoft.module.store::message.unauthorized_access'));
            }

            $offer_id = $this->request->offer_id;
            $id = $this->request->id;

            $auction_entry = $this->liveBidRepository->findAdByStoreId($store->id, $id);

            if ($auction_entry and $entry = $auction_entry->adv and $offer = $this->offerRepository->find($offer_id)) {
                if ($entry = $this->liveBidRepository->findAdByStoreId($store->id, $auction_entry->adv_id)) {
                    if ($this->request->action == "sold") {
                        $entry->setAttribute('status', 'sold');
                    } else if ($this->request->action == "skip") {
                        $entry->setAttribute('status', 'unsold');
                    }
                    $entry->setAttribute('offer_id', $offer->id);
                    $entry->save();

                    $offer->setAttribute('status', 'sold');
                    $offer->save();

                    $response["status"] = true;
                }
            }
        }
        return $this->response->json($response);
    }

    public function agoraToken()
    {
        $response = ['status' => false];

        if ($this->request->has(['channel_name', 'uid'])) {
            $response['data'] = dispatch_now(new BuildToken($this->request->channel_name, $this->request->uid));
            $response['status'] = true;
        }

        return $this->response->json($response);
    }
}
