<?php namespace Visiosoft\AuctionsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AuctionsModule\LiveBid\Contract\LiveBidRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class StoreController extends ResourceController
{

    protected $repository;
    protected $adv;
    protected $customFieldRepository;
    protected $liveBidRepository;

    public function __construct(StoreRepositoryInterface $repository, AdvRepositoryInterface $advRepository, CustomFieldRepositoryInterface $customFieldRepository, LiveBidRepositoryInterface $liveBidRepository)
    {
        $this->repository = $repository;
        $this->adv = $advRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->liveBidRepository = $liveBidRepository;
        parent::__construct();
    }

    public function panel($slug)
    {
        $store = $this->repository->findBySlug($slug);

        if ($store->user_id !== \auth()->id()) {
            abort(403, trans('visiosoft.module.store::message.unauthorized_access'));
        }

        $auction_entries = $this->liveBidRepository->getByStoreId($store->id);

        $live = $auction_entries->filter(
            function ($entry) {
                return $entry->status == null;
            }
        );

        $completed = $auction_entries->filter(
            function ($entry) {
                return $entry->status != null;
            }
        );

        $sold = $auction_entries->filter(
            function ($entry) {
                return $entry->status == "sold";
            }
        );
        $sold = $sold->pluck('adv_id')->all();

        $unsold = $auction_entries->filter(
            function ($entry) {
                return $entry->status == "unsold";
            }
        );
        $unsold = $unsold->pluck('adv_id')->all();

        $pending_auction_products = $this->customFieldRepository
            ->QueryAdsWithCFValue('urun_tipi', setting_value('visiosoft.module.auctions::auction_customfields_value'))
            ->whereNotIn('advs_advs.id', $auction_entries->pluck('adv_id')->all())
            ->get();

        $pending_auction_products = $pending_auction_products->filter(
            function ($entry) {
                return $entry->created_by_id == Auth::id();
            }
        );

        $pending_auction_products = $this->adv->addAttributes($pending_auction_products);


        $live_auction_products = $this->customFieldRepository
            ->QueryAdsWithCFValue('urun_tipi', setting_value('visiosoft.module.auctions::auction_customfields_value'))
            ->whereIn('advs_advs.id', $live->pluck('adv_id')->all())
            ->get();

        $live_auction_products = $live_auction_products->filter(
            function ($entry) {
                return $entry->created_by_id == Auth::id();
            }
        );

        $live_auction_products = $this->adv->addAttributes($live_auction_products);

        $completed_auction_products = $this->customFieldRepository
            ->QueryAdsWithCFValue('urun_tipi', setting_value('visiosoft.module.auctions::auction_customfields_value'))
            ->whereIn('advs_advs.id', $completed->pluck('adv_id')->all())
            ->get();

        $completed_auction_products = $completed_auction_products->filter(
            function ($entry) {
                return $entry->created_by_id == Auth::id();
            }
        );

        $completed_auction_products = $this->adv->addAttributes($completed_auction_products);


        $storeUsers = $store->getStoreUsers();
        $usersIds = $storeUsers->pluck('id');

        $ads = $this->adv
            ->getByUsersIDs($usersIds, false, true)
            ->whereNotIn('advs_advs.id', $auction_entries->pluck('adv_id')->all())
            ->whereNotIn('advs_advs.id', $pending_auction_products->pluck('id')->all())
            ->get();

        $ads = $this->adv->addAttributes($ads);

        return view('visiosoft.module.auctions::store.panel',
            compact('store', 'ads', 'pending_auction_products', 'live_auction_products', 'completed_auction_products', 'sold', 'unsold'));
    }

    public function actionsAuctions($slug)
    {
        $store = $this->repository->findBySlug($slug);

        if ($this->request->has(['items', 'action']) and $count = count($this->request->items)) {

            $action = $this->request->action;
            $items = $this->request->items;

            if ($action == "unpublish") {
                $this->unpublish($count, $items);
            } elseif ($action == "publish") {
                $this->publish($items, $count, $store);
            } elseif ($action == "sold") {
                $this->sold($items, $count);
            } elseif ($action == "unsold") {
                $this->unsold($items, $count);
            } elseif ($action == "move") {
                $this->move($items, $count);
            }
        }
        return $this->redirect->route('store::store_panel', ['slug' => $store->slug]);
    }

    public function unpublish($count, $items)
    {
        $this->liveBidRepository->newQuery()->whereIn('adv_id', $items)->delete();
        $this->messages->success(trans('module::messages.removed_from_display', ['count' => $count]));
    }

    public function publish($items, $count, $store)
    {
        foreach ($items as $item) {
            if (!$entry = $this->liveBidRepository->findBy('adv_id', $item)) {
                $this->liveBidRepository->createNew($store->id, $item);
            } else {
                $entry->update(['status' => null]);
            }
        }
        $this->messages->success(trans('module::messages.products_on_display', ['count' => $count]));
    }

    public function sold($items, $count)
    {
        $this->liveBidRepository->getByAdsAndUpdateStatus($items, 'sold');
        $this->messages->success(trans('module::messages.sold', ['count' => $count]));
    }

    public function unsold($items, $count)
    {
        $this->liveBidRepository->getByAdsAndUpdateStatus($items, 'unsold');
        $this->messages->success(trans('module::messages.not_sold', ['count' => $count]));
    }

    public function move($items, $count)
    {
        $customfield = $this->customFieldRepository->findBySlug('urun_tipi');

        foreach ($items as $item) {
            if ($adv = $this->adv->newQuery()->find($item) and $customfield) {
                $customfield_values_by_adv = json_decode($adv->cf_json, true);
                $customfield_values_by_adv["cf" . $customfield->id] = setting_value('visiosoft.module.auctions::auction_customfields_value');
                $adv->cf_json = json_encode($customfield_values_by_adv);
                $adv->save();
            }
        }

        $this->messages->success(trans('module::messages.updated_as_auctions', ['count' => $count]));
    }

    public function stream($slug)
    {
        if ($store = $this->repository->findBySlug($slug)) {

            $auction_entries = $this->liveBidRepository->getByStoreId($store->id);

            $live = $auction_entries->filter(
                function ($entry) {
                    return $entry->status == null;
                }
            );

            $live_auction_products = $this->customFieldRepository
                ->QueryAdsWithCFValue('urun_tipi', setting_value('visiosoft.module.auctions::auction_customfields_value'))
                ->whereIn('advs_advs.id', $live->pluck('adv_id')->all())
                ->get();

            if (count($live_auction_products)) {
                $live_auction_products = $this->adv->addAttributes($live_auction_products);

                return $this->view->make('visiosoft.module.auctions::stream', compact('store', 'live_auction_products'));
            }
        }
        abort(404,trans('visiosoft.module.auctions::messages.error_stream'));
    }
}
