<?php namespace Visiosoft\AuctionsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AuctionsModule\LiveBid\Contract\LiveBidRepositoryInterface;
use Visiosoft\AuctionsModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\AuctionsModule\Agora\BuildToken;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class AjaxController extends ResourceController
{

    protected $repository;
    protected $adv;
    protected $customFieldRepository;
    protected $liveBidRepository;
    protected $offerRepository;
    protected $orderModel;
    protected $orderdetailModel;

    public function __construct(
        StoreRepositoryInterface $repository,
        AdvRepositoryInterface $advRepository,
        CustomFieldRepositoryInterface $customFieldRepository,
        LiveBidRepositoryInterface $liveBidRepository,
        OrderModel $orderModel,
        OrderdetailModel $orderdetailModel,
        OfferRepositoryInterface $offerRepository)
    {
        $this->repository = $repository;
        $this->adv = $advRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->liveBidRepository = $liveBidRepository;
        $this->offerRepository = $offerRepository;
        $this->orderModel = $orderModel;
        $this->orderdetailModel = $orderdetailModel;
        parent::__construct();
    }

    public function send($slug)
    {
        if ($store = $this->repository->findBySlug($slug) and $this->request->has(['bid_price', 'id'])) {

            $bid_price = $this->request->bid_price;
            $id = $this->request->id;

            if ($auction_entry = $this->liveBidRepository->findAdByStoreId($store->id, $id) and $entry = $auction_entry->adv) {

                $response_ajax = ['status' => false, 'message' => ''];

                if ($last_request = $this->offerRepository->getLastOfferByAdv($auction_entry->adv_id)) {

                    // Check Last Price
                    if ($last_request->bid_price < $bid_price) {

                        $this->offerRepository->createNew($store->id, $auction_entry->adv_id, $bid_price);
                        $response_ajax['status'] = true;
                    } else {
                        $response_ajax['message'] = trans('visiosoft.module.auctions::messages.error_previous_offer');
                    }

                } elseif ($entry->price < floatval($bid_price)) {

                    // Check Start Price

                    $this->offerRepository->createNew($auction_entry->adv_id, $bid_price, $store->id);
                    $response_ajax['status'] = true;

                } else {
                    $response_ajax['message'] = trans('visiosoft.module.auctions::messages.error_start_price');
                }

                return $this->response->json($response_ajax);
            }
        }
        abort(403);
    }

    public function last($id)
    {
        $entry = $this->liveBidRepository->findBy('adv_id', $id);

        if ($entry && in_array($entry->status, ['sold', 'unsold'])) {
            return $this->response->json(['status' => $entry->status]);
        }

        $offers = $this->offerRepository->getOffersByAdv($id);

        if ($this->request->has('type') and $this->request->type == "view") {
            return $this->view->make('visiosoft.module.auctions::last-offers', compact('offers'));
        }

        return $this->response->json($offers);
    }

    public function complete($slug)
    {
        $response = ["status" => false, "message" => ""];

        if ($store = $this->repository->findBySlug($slug) and $this->request->has(['id', 'action'])) {

            if ($store->user_id !== \auth()->id()) {
                $response["message"] = trans('visiosoft.module.store::message.unauthorized_access');
            }

            $id = $this->request->id;
            $auction_entry = $this->liveBidRepository->findAdByStoreId($store->id, $id);

            if ($auction_entry) {
                if ($this->request->action == "sold" and $this->request->has('offer_id')) {

                    $offer_id = $this->request->offer_id;

                    if ($entry = $auction_entry->adv and $offer = $this->offerRepository->find($offer_id)) {

                        $auction_entry->setAttribute('status', 'sold');

                        // Update Ad For Sold
                        $this->soldAd($auction_entry->adv_id, $offer);

                        $auction_entry->setAttribute('offer_id', $offer->id);
                        $auction_entry->save();

                        $offer->setAttribute('status', 'sold');
                        $offer->save();
                    } else {
                        $response["message"] = trans('visiosoft.module.store::message.error_ad_or_offer');
                    }
                } else {
                    $auction_entry->setAttribute('status', 'unsold');
                    $auction_entry->save();
                }
                $response["status"] = true;
            } else {
                $response["message"] = trans('visiosoft.module.store::message.auction_found');
            }
        }

        return $this->response->json($response);
    }

    public function agoraToken()
    {
        $response = ['status' => false];

        if ($this->request->has(['channel_name', 'uid'])) {
            $response['data'] = dispatch_now(new BuildToken($this->request->channel_name, $this->request->uid));
            $response['status'] = true;
        }

        return $this->response->json($response);
    }

    /**
     * @param $id
     * @param $offer
     * It updates the stock number of the sold auction product to 0 in the classifieds table and creates
     * an order for the person who bought the product.
     */
    public function soldAd($id, $offer)
    {

        if ($adv = $this->adv->find($id)) {
            $adv->setAttribute('is_get_adv', true);
            $adv->setAttribute('stock', 0);
            $adv->save();
        }

        $shipping = setting_value('visiosoft.module.orders::shipping');
        $tax = setting_value('visiosoft.module.orders::tax');
        $currency = setting_value('streams::currency');

        // Calculate Total
        $total = $shipping +
            $tax +
            $offer->bid_price;
        // Create Order
        $order_id = $this->orderModel->newQuery()->create([
            'user' => $offer->created_by,
            'pay_type' => 'order',
            'total' => $total,
            'type' => 'adv',
            'subtotal' => $offer->bid_price,
            'shipping' => $shipping,
            'tax' => $tax,
            'currency' => $currency,
            'status' => 'pending',
            'order_at' => date('Y-m-d H:i:s'),
        ]);

        // Create Detail
        $order_detail_params = [
            'item_id' => $id,
            'item_type' => 'adv',
            'price' => $offer->bid_price,
            'currency' => $offer->adv->currency,
            'piece' => 1,
            'total' => $offer->bid_price,
            'order' => $order_id,
            'status' => 'awaiting_payment',
        ];

        return $this->orderdetailModel->create_datail($order_detail_params);
    }

    public function auctionsIwon($id)
    {
        $products = $this->offerRepository->getIWonByStore($id);

        return $this->view->make('visiosoft.module.auctions::partials/auctions-i-won', compact('products'));
    }

    public function auctionsWinner($id)
    {
        $products = $this->offerRepository->getWinnerByStore($id);

        return $this->view->make('visiosoft.module.auctions::partials/auctions-winner', compact('products'));
    }

    public function createOffer()
    {
        $validator = Validator::make(request()->all(), [
            'adv_id' => 'required',
            'bid_price' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json(['messages' => $validator->errors()->messages(), 'status' => false], 200);
        }

        $bid_price = $this->request->get('bid_price');
        $adv_id = $this->request->get('adv_id');

        $last = $this->offerRepository->getLastOfferByAdv($adv_id);

        if ($last && $last->bid_price >= $bid_price) {
            return $this->response->json(['status' => false, 'messages' => [trans('visiosoft.module.auctions::messages.error_previous_offer')]]);
        }

        $this->offerRepository->createNew($adv_id, $bid_price);

        return $this->response->json(['status' => true, 'messages' => [trans('visiosoft.module.auctions::messages.submitted_bid')]]);
    }

    public function completeSold($id)
    {
        $offer = $this->offerRepository->find($id);

        if ($offer && $offer->adv && $offer->adv->created_by_id == Auth::id()) {

            if ($offer->status != "sold") {
                $offer->setAttribute('status', 'sold');
                $offer->save();

                $order_id = $this->soldAd($offer->adv_id, $offer);

                return $this->response->json(['redirect' => route('orders::sale_detail', ['id' => $order_id])]);
            } else {
                $this->messages->error(trans('visiosoft.module.auctions::messages.sold_before'));
            }

        } else {
            $this->messages->error(trans('visiosoft.module.auctions::messages.error_ad_or_offer'));
        }

        return $this->response->json(['redirect' => route('adv_list_seo')]);
    }
}
