<?php namespace Visiosoft\AuctionsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\AuctionsModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\AuctionsModule\Offer\OfferRepository;
use Anomaly\Streams\Platform\Model\Auctions\AuctionsOffersEntryModel;
use Visiosoft\AuctionsModule\Offer\OfferModel;
use Visiosoft\AuctionsModule\LiveBid\Contract\LiveBidRepositoryInterface;
use Visiosoft\AuctionsModule\LiveBid\LiveBidRepository;
use Anomaly\Streams\Platform\Model\Auctions\AuctionsLiveBidsEntryModel;
use Visiosoft\AuctionsModule\LiveBid\LiveBidModel;
use Illuminate\Routing\Router;

class AuctionsModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/auctions/offers' => 'Visiosoft\AuctionsModule\Http\Controller\Admin\OffersController@index',
        'admin/auctions/offers/create' => 'Visiosoft\AuctionsModule\Http\Controller\Admin\OffersController@create',
        'admin/auctions/offers/edit/{id}' => 'Visiosoft\AuctionsModule\Http\Controller\Admin\OffersController@edit',
        'admin/auctions' => 'Visiosoft\AuctionsModule\Http\Controller\Admin\LiveBidsController@index',
        'admin/auctions/create' => 'Visiosoft\AuctionsModule\Http\Controller\Admin\LiveBidsController@create',
        'admin/auctions/edit/{id}' => 'Visiosoft\AuctionsModule\Http\Controller\Admin\LiveBidsController@edit',

        'store/panel/{slug}/action-auctions' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\StoreController@actionsAuctions',
            'as' => 'visiosoft.module.auctions::panel.action-auctions',
        ],
        'auction/stream/{slug}' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\StoreController@stream',
            'as' => 'visiosoft.module.auctions::auctions.stream',
        ],

        'ajax/auction/send/{slug}' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\AjaxController@send',
            'as' => 'visiosoft.module.auctions::ajax.auctions.send',
        ],
        'ajax/auction/last/{id}' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\AjaxController@last',
            'as' => 'visiosoft.module.auctions::ajax.auctions.last',
        ],

        'ajax/auction/complete/{slug}' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\AjaxController@complete',
            'as' => 'visiosoft.module.auctions::ajax.auctions.complete',
        ],

        'ajax/agora/getToken' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\AjaxController@agoraToken',
            'as' => 'visiosoft.module.auctions::ajax.agora.get-token',
        ],

        'ajax/auction/i-won/{id}' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\AjaxController@auctionsIwon',
            'as' => 'visiosoft.module.auctions::ajax.auctions.i_won',
        ],
        'ajax/auction/winners/{id}' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\AjaxController@auctionsWinner',
            'as' => 'visiosoft.module.auctions::ajax.auctions.winners',
        ],

        'ajax/create-offer' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\AjaxController@createOffer',
            'as' => 'visiosoft.module.auctions::ajax.auctions.create_offer',
        ],

        'ajax/complete-sold/{id}' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\AjaxController@completeSold',
            'as' => 'visiosoft.module.auctions::ajax.complete_sold',
        ],
    ];

    protected $bindings = [
        AuctionsOffersEntryModel::class => OfferModel::class,
        AuctionsLiveBidsEntryModel::class => LiveBidModel::class,
    ];

    protected $singletons = [
        OfferRepositoryInterface::class => OfferRepository::class,
        LiveBidRepositoryInterface::class => LiveBidRepository::class,
    ];

    public function map(Router $router)
    {
        if (config('auctions.override_panel')) {
            //Override Store Panel Route
            $router->get(
                'store/panel/{slug}',
                [
                    'uses' => 'Visiosoft\AuctionsModule\Http\Controller\StoreController@panel',
                    'as' => 'store::store_panel',
                ]
            )->middleware('auth');

            //Override Store List Route
            $router->get(
                'store/{slug}',
                [
                    'uses' => 'Visiosoft\AuctionsModule\Http\Controller\StoreController@index',
                    'as' => 'store::view',
                ]
            );
        }
    }

}
