<?php

return [
    'agora_app_id' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => '7e531d2050e44c88a2e102314838e452'
        ],
    ],
    'agora_certificate_id' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'bd569a4ed24d4bb09c0cbdf0dac20ce1'
        ],
    ],
    'auction_customfields_value' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'options' => function (\Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface $customFieldRepository,
                                   \Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface $cfvalueRepository) {
                if ($customfield = $customFieldRepository->findBySlug('urun_tipi')) {
                    return $cfvalueRepository->newQuery()->where('custom_field_id',$customfield->getId())
                        ->get()
                        ->pluck('custom_field_value', 'id')
                        ->all();
                }
                return [];
            },
        ],
    ],
    'override-panel' => [
        'type' => 'anomaly.field_type.boolean',
        'bind' => 'auctions.override_panel',
        'config' => [
            'default_value' => false
        ],
    ],
];
