// Init Other Products Slider
new Swiper('.other-products-swiper', {
    slidesPerView: 1,
    spaceBetween: 5,
    navigation: {
        prevEl: '.other-products-prev',
        nextEl: '.other-products-next',
    },
    breakpoints: {
        425: {
            slidesPerView: 2,
        },
        576: {
            spaceBetween: 30,
        },
        768: {
            slidesPerView: 3,
        },
        992: {
            slidesPerView: 4,
        },
    }
});


// Send
$('#send-auction').on('submit', function (e) {
    e.preventDefault();

    let price = $('#request-price').val();
    let adv = auction_options.active_product;

    crudAjax({'id': adv, 'bid_price': price}, auction_options.send_url, 'POST', function (response) {
        if (!response.status) {
            if(response.message != ""){
                Swal.fire(response.message)
            }
        }
        //Reset Form Value
        $('#request-price').val("");
    })
});

let syncOffers = {
    init: function () {
        $.when(
            crudAjax('', '/ajax/auction/last/' + auction_options.active_product + '?type=view', 'GET', function (data) {
                if (typeof data.status != "undefined") {
                    setActiveProduct(auction_options.next);
                } else {
                    $('.last-area').html(data);
                }
            }, true)
        ).done(function () {

            let last_item = $('.last-area li:last-child');

            if (last_item.length > 0) {
                // Set last ID
                $('.complete-auction').data('id', last_item.data('id'));

                // Set Min Price
                $('#request-price').attr('min', last_item.data('min'))
            } else {
                // Set last ID
                $('.complete-auction').data('id', "");

                // Set Min Price
                $('#request-price').attr('min', $('#product-price').data('min'))
            }
        });
    }
};

syncOffers.init();

// Complete

$('.complete-auction').on('submit', function (e) {
    e.preventDefault();

    let form = $(this);
    let offer_id = form.data('id');
    let id = auction_options.active_product;
    let action = form.find('button').val();

    if(action == "skip" || offer_id == "")
    {
        Swal.fire({
            title: 'Bu Ürünü atlamak istediğinizden emin misiniz?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Evet!',
            cancelButtonText: 'iptal'
        }).then((result) => {
            if (result.isConfirmed) {
                completeRequest({
                    'id': id,
                    'action': 'skip'
                });
            }
        })
    } else {
        completeRequest({
            'id': id,
            'offer_id': offer_id,
            'action': action
        });
    }
});

function completeRequest(params) {
    crudAjax(params, auction_options.complete_url, 'POST', function (response) {
        if (!response.status) {
            if(response.message != ""){
                Swal.fire(response.message)
            }
        } else {
            if (typeof auction_options.next != "undefined") {
                setActiveProduct(auction_options.next);
            } else {
                $('.detail-area , .bids-area, .other-products-slider-wrapper').remove();
            }
        }
    });
}

function setActiveProduct(id) {

    if (typeof id != "undefined") {
        // Set Active Product
        let old_product = auction_options.active_product;
        auction_options.active_product = id;

        // Remove
        removeSlide(old_product);

        // Set Product Detail Area
        crudAjax('', '/api/entries/advs/advs/' + id, 'GET', function (response) {
            if (response.data) {
                let entry = response.data;
                let created_at = new Date(entry.created_at);

                $('#product-name').html(entry.name);
                $('#product-image').attr('src', entry.thumbnail).attr('alt', entry.name);
                $('#product-created').html(created_at.getDate() + "." + created_at.getMonth() + "." + created_at.getFullYear());
                $('#product-description').html(entry.advs_desc);
                $('#product-price').html(entry.currency_price);
                $('#product-price').data('min', entry.price)

                // Set Next Product
                syncProduct();
            }
        });
    } else {
        $('.detail-area , .bids-area, .other-products-slider-wrapper').remove();
    }
}

function removeSlide(id) {
    $('.swiper-slide[data-id="' + id + '"]').remove();
}

let syncProduct = function () {

    let active_index = $.inArray(parseInt(auction_options.active_product), auction_options.live_auction_products);

    if (auction_options.live_auction_products.length > active_index + 1) {
        auction_options.next = auction_options.live_auction_products[active_index + 1];
    } else {
        auction_options.next = undefined;
    }
};

syncProduct();

let syncIwonOrWinner = {
    iWon: function () {
        this.init('/ajax/auction/i-won/' + auction_options.store_id, '.auctions-i-won-area');
    },
    winner: function () {
        this.init('/ajax/auction/winners/' + auction_options.store_id, '.auctions-winner-area');
    },
    init: function (url, elementClass) {
        crudAjax('', url, 'GET', function (data) {
            $(elementClass).html(data);
        }, true)
    }
};

if (auction_options.is_owner) {
    syncIwonOrWinner.winner()
} else {
    syncIwonOrWinner.iWon()
}

function redirectMyPurchase() {
    Swal.fire({
        title: translate_auctions.redirect_purchase.title,
        text: translate_auctions.redirect_purchase.text,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: '<i class="fa fa-thumbs-up"></i> ' + translate_auctions.redirect_purchase.confirmButtonText,
        cancelButtonText: translate_auctions.redirect_purchase.cancelButtonText,
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = auction_options.my_purchase_url;
        }
    })
}


setInterval(function () {
    syncOffers.init();
    if (auction_options.is_owner) {
        syncIwonOrWinner.winner()
    } else {
        syncIwonOrWinner.iWon()
    }
}, 1000);
