<?php namespace Visiosoft\AuctionsModule\LiveBid;

use Visiosoft\AuctionsModule\LiveBid\Contract\LiveBidRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class LiveBidRepository extends EntryRepository implements LiveBidRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var LiveBidModel
     */
    protected $model;

    /**
     * Create a new LiveBidRepository instance.
     *
     * @param LiveBidModel $model
     */
    public function __construct(LiveBidModel $model)
    {
        $this->model = $model;
    }

    public function getByStoreId($store_id)
    {
        return $this->newQuery()->where('store_id', $store_id)->get();
    }
}
