<?php namespace Visiosoft\AuctionsModule\Http\Controller;

use Anomaly\PagesModule\Page\Contract\PageInterface;
use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AuctionsModule\LiveBid\Contract\LiveBidRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class StoreController extends ResourceController
{

    protected $repository;
    protected $adv;
    protected $customFieldRepository;
    protected $liveBidRepository;

    public function __construct(StoreRepositoryInterface $repository, AdvRepositoryInterface $advRepository, CustomFieldRepositoryInterface $customFieldRepository, LiveBidRepositoryInterface $liveBidRepository)
    {
        $this->repository = $repository;
        $this->adv = $advRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->liveBidRepository = $liveBidRepository;
        parent::__construct();
    }

    public function panel($slug)
    {
        $store = $this->repository->findBySlug($slug);

        if ($store->user_id !== \auth()->id()) {
            abort(403, trans('visiosoft.module.store::message.unauthorized_access'));
        }

        $auction_entries = $this->liveBidRepository->getByStoreId($store->id);

        $live = $auction_entries->filter(
            function ($entry) {
                return $entry->status == null;
            }
        );

        $completed = $auction_entries->filter(
            function ($entry) {
                return $entry->status != null;
            }
        );

        $sold = $auction_entries->filter(
            function ($entry) {
                return $entry->status == "sold";
            }
        );
        $sold = $sold->pluck('adv_id')->all();

        $unsold = $auction_entries->filter(
            function ($entry) {
                return $entry->status == "unsold";
            }
        );
        $unsold = $unsold->pluck('adv_id')->all();

        $pending_auction_products = $this->customFieldRepository
            ->QueryAdsWithCFValue('urun_tipi', setting_value('visiosoft.module.auctions::auction_customfields_value'))
            ->whereNotIn('advs_advs.id', $auction_entries->pluck('adv_id')->all())
            ->get();
        $pending_auction_products = $this->adv->addAttributes($pending_auction_products);


        $live_auction_products = $this->customFieldRepository
            ->QueryAdsWithCFValue('urun_tipi', setting_value('visiosoft.module.auctions::auction_customfields_value'))
            ->whereIn('advs_advs.id', $live->pluck('adv_id')->all())
            ->get();
        $live_auction_products = $this->adv->addAttributes($live_auction_products);

        $completed_auction_products = $this->customFieldRepository
            ->QueryAdsWithCFValue('urun_tipi', setting_value('visiosoft.module.auctions::auction_customfields_value'))
            ->whereIn('advs_advs.id', $completed->pluck('adv_id')->all())
            ->get();
        $completed_auction_products = $this->adv->addAttributes($completed_auction_products);


        $storeUsers = $store->getStoreUsers();
        $usersIds = $storeUsers->pluck('id');

        $ads = $this->adv
            ->getByUsersIDs($usersIds, false, true)
            ->whereNotIn('advs_advs.id', $auction_entries->pluck('adv_id')->all())
            ->whereNotIn('advs_advs.id', $pending_auction_products->pluck('id')->all())
            ->get();

        $ads = $this->adv->addAttributes($ads);

        return view('visiosoft.module.auctions::store.panel',
            compact('store', 'ads', 'pending_auction_products', 'live_auction_products', 'completed_auction_products', 'sold', 'unsold'));
    }

    public function actionsAuctions($slug)
    {
        if ($this->request->has(['items', 'action']) and $store = $this->repository->findBySlug($slug) and $count = count($this->request->items)) {

            $action = $this->request->action;
            $items = $this->request->items;

            if ($action == "unpublish") {
                $this->liveBidRepository->newQuery()->whereIn('adv_id', $items)->delete();
                $this->messages->success([$count . ' ürün yayından kaldırıldı!']);
            } elseif ($action == "publish") {
                foreach ($items as $item) {
                    $this->liveBidRepository->newQuery()->create([
                        'store_id' => $store->id,
                        'adv_id' => $item
                    ]);
                }
                $this->messages->success([$count . ' ürün yayınlandı!']);
            } elseif ($action == "sold") {
                $this->liveBidRepository->newQuery()->whereIn('adv_id', $items)
                    ->update(['status' => 'sold']);
                $this->messages->success([$count . ' ürün satıldı olarak güncellendi!']);
            } elseif ($action == "unsold") {
                $this->liveBidRepository->newQuery()->whereIn('adv_id', $items)
                    ->update(['status' => 'unsold']);
                $this->messages->success([$count . ' ürün satılmadı olarak güncellendi!']);
            }
        }
        return $this->redirect->route('store::store_panel', ['slug' => $store->slug]);
    }
}
