<?php namespace Visiosoft\AuctionsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\AuctionsModule\LiveBid\Contract\LiveBidRepositoryInterface;
use Visiosoft\AuctionsModule\LiveBid\LiveBidRepository;
use Anomaly\Streams\Platform\Model\Auctions\AuctionsLiveBidsEntryModel;
use Visiosoft\AuctionsModule\LiveBid\LiveBidModel;
use Illuminate\Routing\Router;

class AuctionsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/auctions' => 'Visiosoft\AuctionsModule\Http\Controller\Admin\LiveBidsController@index',
        'admin/auctions/create' => 'Visiosoft\AuctionsModule\Http\Controller\Admin\LiveBidsController@create',
        'admin/auctions/edit/{id}' => 'Visiosoft\AuctionsModule\Http\Controller\Admin\LiveBidsController@edit',

        'store/panel/{slug}/action-auctions' => [
            'uses' => 'Visiosoft\AuctionsModule\Http\Controller\StoreController@actionsAuctions',
            'as' => 'visiosoft.module.auctions::panel.action-auctions',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\AuctionsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\AuctionsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\AuctionsModule\Event\ExampleEvent::class => [
        //    Visiosoft\AuctionsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\AuctionsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        AuctionsLiveBidsEntryModel::class => LiveBidModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        LiveBidRepositoryInterface::class => LiveBidRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        //Override Store Panel Route
        $router->get(
            'store/panel/{slug}',
            [
                'uses' => 'Visiosoft\AuctionsModule\Http\Controller\StoreController@panel',
                'as' => 'store::store_panel',
            ]
        )->middleware('auth');
    }

}
