<?php

namespace Visiosoft\ApiGooglecontactsExtension\Event;

use Visiosoft\ApiGooglecontactsExtension\Models\Contact;

class ContactsReceivedEvent
{
    private array $contacts = [];

    /**
     * @param string $name
     * @param string $email
     * @param string $phone
     * @return void
     */
    public function setContact(string $name, string $email, string $phone): void
    {
        $this->contacts[] = new Contact($name, $email, $phone);
    }

    /**
     * @return array
     */
    public function getContacts(): array
    {
        return $this->contacts;
    }

}